﻿using PpmsDataWebService.Models;
using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using System.Web.Http.Description;
using Microsoft.Web.Http;

namespace PpmsDataWebService.Controllers
{
    //[Authorize]
    [EnableQuery]
    [ApiVersion("1.0")]       
    public class ProviderNetworksController : ODataController
    {
        
        [ODataRoute("ProviderNetworks({NetworkId})")]
        public async Task<HttpResponseMessage> Get(int NetworkId)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //look up the network id in model. 
                //var network = NetworkIds.GetNetwork(key);
                //Retrieve the Provider Network
                var ppmsProviderNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.ppms_networknumber == NetworkId);
                if (ppmsProviderNetwork != null)
                {
                    var ppmsProviderNetworkList = new List<ppms_vaprovidernetwork> { ppmsProviderNetwork };
                    var providerNetwork = await ProviderNetworkMap.MapProviderNetworks(ppmsProviderNetworkList, queryType, context);
                    return Request.CreateResponse(providerNetwork);
                }
            }
            var message = string.Format("No VA Provider Network found for given Network Id");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }
        

        [ODataRoute("ProviderNetworks")]
        public async Task<HttpResponseMessage> Get()
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Networks 
                var ppmsProviderNetworks = context.ppms_vaprovidernetworkSet
                    .Where(i => i.ppms_name != null && i.StatusCode.Value == (int)ppms_vaprovidernetwork_StatusCode.Active).Take(50);
                var ppmsProviderNetworksList = ppmsProviderNetworks.ToList();
                if (ppmsProviderNetworksList.Any())
                {
                    var providerNetworks = await ProviderNetworkMap.MapProviderNetworks(ppmsProviderNetworksList, queryType, context);                   
                    return Request.CreateResponse(providerNetworks);
                }
            }
            var message = string.Format("Provider Networks Not Found");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }



    }
}